<?php
Class Site extends CI_Controller{

   function __construct()
   {
	 parent::__construct();
	 $this->load->model('View_data');
	 $this->load->helper(array('html','language','form','text'));
     $this->load->helper('my_helper');
	 $this->load->model('Search_data');
	 $this->load->model('Common_model');
	 $this->load->library('form_validation');
    }

     public function index()
    {
       $data['title'] = 'Bhandardara Lakeside Camping';
       $data['description'] = 'Bhandardara | Enjoy best Lakeside Camping experience with Trekking, Tent , Bonfire , Boating | Beautiful Sunset, Mouthwatering Local Cuisine and BBQ. Instant Booking | Call Now @ 8805090983';
       $data['keywords'] = 'lakeside camping at bhandardara, bhandardara lakeside camping, camping in bhandardara, boating in bhandardara, campfire in bhabdardara, trekking in bhandardara, Instant Booking';
       $data['page'] = 'index';
	   $data['about'] = $this->View_data->about();
	   $data['contact'] = $this->View_data->getprofile();
	   $data['slider'] = $this->View_data->getslider();
	   $data['service'] = $this->View_data->get_service();
	   $data['services'] = $this->View_data->get_service();
	   $data['test'] = $this->View_data->get_test_random();
	   $data['locations'] = $this->View_data->get_location();
	   $data['location'] = $this->View_data->get_location_limit();
	   $data['gallery'] = $this->View_data->get_gallery_random();
       $this->load->view('Frontend/index', $data);
    }
    
     public function home()
    {
       $data['title'] = 'Bhandardara Lakeside Camping';
       $data['description'] = 'Bhandardara | Enjoy best Lakeside Camping experience with Trekking, Tent , Bonfire , Boating | Beautiful Sunset, Mouthwatering Local Cuisine and BBQ. Instant Booking | Call Now @ 8805090983';
       $data['keywords'] = 'lakeside camping at bhandardara, bhandardara lakeside camping, camping in bhandardara, boating in bhandardara, campfire in bhabdardara, trekking in bhandardara, Instant Booking';
       $data['page'] = 'index';
	   $data['about'] = $this->View_data->about();
	   $data['contact'] = $this->View_data->getprofile();
	   $data['slider'] = $this->View_data->getslider();
	   $data['service'] = $this->View_data->get_service();
	   $data['services'] = $this->View_data->get_service();
	   $data['test'] = $this->View_data->get_test_random();
	   $data['locations'] = $this->View_data->get_location();
	   $data['location'] = $this->View_data->get_location_limit();
	   $data['gallery'] = $this->View_data->get_gallery_random();
       $this->load->view('Frontend/index', $data);
    }

	public function package()
    {
      $data['title'] = 'Our Packages';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'site';
      $data['about'] = $this->View_data->about();
      $data['contact'] = $this->View_data->getprofile();
      $data['slider'] = $this->View_data->getslider();
      $data['test'] = $this->View_data->get_testmonial();
      $data['services'] = $this->View_data->get_service();
      $data['locations'] = $this->View_data->get_location();
      $this->load->view('Frontend/package', $data);
    }

    public function booking()
    {
      $data['title'] = 'Book-Now';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'site';
      $data['about'] = $this->View_data->about();
      $data['contact'] = $this->View_data->getprofile();
      $data['slider'] = $this->View_data->getslider();
      $data['service'] = $this->View_data->get_service();
      $data['test'] = $this->View_data->get_testmonial();
      $data['services'] = $this->View_data->get_service();
      $data['locations'] = $this->View_data->get_location();
      $this->load->view('Frontend/booking', $data);
    }
    public function sitemap()
    {
      $this->load->view('sitemap');
    }


	  public function vission()
    {	  
      $data['title'] = 'Vission & Mission';
      $data['page'] = 'Home';
	  $data['about'] = $this->View_data->about();
	  $data['services'] = $this->View_data->get_service();
	  $data['locations'] = $this->View_data->get_location();
	  $data['contact'] = $this->View_data->getprofile();
      $this->load->view('Frontend/vission', $data);
    }

	  public function view_site()

    {
      $data['title'] = ' Home';
      $data['page'] = 'Home';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['locations'] = $this->View_data->get_location();
	  $this->load->view('Frontend/view_site', $data);
    }

	public function disclaimer()
	{
      $data['title'] = 'Bhandardara Lakeside Camping: Disclaimer ';
      $data['page'] = 'Shop-Cart';
      $data['description'] = '';
      $data['keywords'] = '';
	  $a_title = 'disclaimer';
      $data['disclaimer'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['locations'] = $this->View_data->get_location();
      $this->load->view('Frontend/disclaimer', $data);
    }

    public function privacy()
	{
      $data['title'] = 'Privacy Policy ';
      $data['page'] = 'Shop-Cart';
      $data['description'] = '';
      $data['keywords'] = '';
	  $data['services'] = $this->View_data->get_service();
	  $a_title = 'privacy';
      $data['privacy'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['locations'] = $this->View_data->get_location();
      $this->load->view('Frontend/privacy', $data);
    }

    public function delivery()
	{
      $data['title'] = 'Bhandardara lakeside Camping ';
      $data['page'] = 'Shop-Cart';
      $data['description'] = '';
      $data['keywords'] = '';
	  $a_title = 'delivary';
      $data['delivery'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['about'] = $this->View_data->about();
	  $data['services'] = $this->View_data->get_service();
	  $data['locations'] = $this->View_data->get_location();
	  $data['contact'] = $this->View_data->getprofile();
      $this->load->view('Frontend/delivery', $data);
    }

    public function terms()
	{
      $data['title'] = 'Terms & Conditions ';
      $data['page'] = 'terms';
      $data['description'] = '';
      $data['keywords'] = '';
	  $a_title = 'terms';
	  $data['terms'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['services'] = $this->View_data->get_service();
	  $data['locations'] = $this->View_data->get_location();
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
      $this->load->view('Frontend/terms', $data);
    }



    public function about()
    {
	  $data['title'] = 'About Us ';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'About';
	  $data['about'] = $this->View_data->about();
	  $data['services'] = $this->View_data->get_service();
	  $data['locations'] = $this->View_data->get_location();
	  $data['contact'] = $this->View_data->getprofile();
      $this->load->view('Frontend/about', $data);
    }

    public function gallery()
    {
      $data['title'] = 'Gallery ';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'Gallery';
	  $data['locations'] = $this->View_data->get_location();
      $data['contact'] = $this->View_data->getprofile();
      $data['about'] = $this->View_data->about();
      $data['services'] = $this->View_data->get_service();
	  $data['gt_type'] = $this->View_data->get_gtype();
      $data['gallery'] = $this->View_data->get_gallery();
      $this->load->view('Frontend/gallery',$data);
    }

      public function contact()
   {
     $data['title'] = ' Contact Us';
     $data['page'] = 'Contact';
     $data['description'] = '';
     $data['keywords'] = '';
	 $data['about'] = $this->View_data->about();
     $data['contact'] = $this->View_data->getprofile();
     $data['services'] = $this->View_data->get_service();
	 $data['locations'] = $this->View_data->get_location();
     $this->load->view('Frontend/contact',$data);
   }
    public function search()
  {
    if(!empty($_POST["search"])) {
		$query ="SELECT * FROM product WHERE p_name like '%" . $_POST["search"] . "%' ORDER BY p_id LIMIT 0,6";
		//$result = $db_handle->runQuery($query);
		$result = $this->db->query($query)->result();
    echo "<ul>";
    if(!empty($result)) {

		foreach($result as $country) {
			echo "<li><a href='".base_url().'product-details/'.rm_blank($country->p_name)."/".base64_encode($country->p_id)."'>".trim($country->p_name)."</a></li>";
		}

		}
		else {
			echo '<li>No Results Found. <small style=color:#0083c9>Please Search Another Keywords....</small></li>';
		}
    }
    echo "</ul>";
  }

	public function service($s_name)
  {
      $s_name =str_replace('-',' ',$s_name);
     $data['title'] = $s_name. ' near Mumbai | Nashik | Pune';
     $data['page'] = 'Service';
     $data['description'] = $s_name.'. looking for '.$s_name.' near Mumbai, Nashik, Pune';
     $data['keywords'] = $s_name.', camping at bhandardara, '.$s_name.' near Mumbai,'. $s_name.' near Nashik, '.$s_name.' near Pune';
     $data['contact'] = $this->View_data->getprofile();
	 $data['service'] = $this->View_data->getservice_name($s_name);
	 $service =$this->Common_model->select_by_id('s_name',$s_name,'service');
	 foreach($service as $row);
	 $s_id = $row->s_id;
     $data['services'] = $this->View_data->get_service();
     $data['about'] = $this->View_data->about();
	 $data['locations'] = $this->View_data->get_location();
     $this->load->view('Frontend/service',$data);
  }
  public function locations()
  {
    $data['title'] = 'Bhandardara Locations : Wilson Dam or Bhandardara Dam | Randha Falls | Day Night Trek Ratnagad | Necklace Waterfall | Sadhan Valley Trek | Umbrella Water Fall | Harishchandragad Trek | Kalsubai Peak Trek | in bhabdardara ';
    $data['description'] = 'Wilson Dam or Bhandardara Dam | Randha Falls | Day Night Trek Ratnagad | Necklace Waterfall | Sadhan Valley Trek | Umbrella Water Fall | Harishchandragad Trek | Kalsubai Peak Trek | in bhabdardara';
    $data['keywords'] = 'Wilson Dam or Bhandardara Dam in bhabdardara, Randha Falls in bhabdardara, Day Night Trek Ratnagad in bhabdardara, Necklace Waterfall in bhabdardara, Sadhan Valley Trek in bhabdardara, Umbrella Water Fall in bhabdardara,  Harishchandragad Trek in bhabdardara, Kalsubai Peak Trek in bhabdardara';
    $data['about'] = $this->View_data->about();
    $data['page'] = 'Locations';
    $data['contact'] = $this->View_data->getprofile();
    $data['locations'] = $this->View_data->get_location();
    $data['services'] = $this->View_data->get_service();
    $this->load->view('Frontend/locations',$data);
  }
  public function location($l_name)
  {
    $data['title'] = str_replace('-',' ',$l_name);
    $l_name =str_replace('-',' ',$l_name);
    $data['page'] = 'Service';
    $data['about'] = $this->View_data->about();
    $data['contact'] = $this->View_data->getprofile();
    $data['location'] = $this->View_data->getlocation_name($l_name);
    $data['services'] = $this->View_data->get_service();
	$data['locations'] = $this->View_data->get_location();
    $this->load->view('Frontend/location',$data);
  }

 public function feedback()
   {
     $data['title'] = ' Feedback ';
     $data['page'] = 'Contact';
     $data['description'] = '';
     $data['keywords'] = '';
	 $data['about'] = $this->View_data->about();
	 $data['locations'] = $this->View_data->get_location();
     $data['contact'] = $this->View_data->getprofile();
     $data['services'] = $this->View_data->get_service();
     $this->load->view('Frontend/feedback',$data);
   }


}
