<?php
Class Site extends CI_Controller{

   function __construct()
   {
	 parent::__construct();
	 $this->load->model('View_data');
	 $this->load->helper(array('html','language','form','text'));
   $this->load->helper('my_helper');
	 $this->load->model('Search_data');
	 $this->load->model('Common_model');
	 $this->load->library('form_validation');

    }

     public function index()
    {
	  $data['title'] = '';
	  $data['description'] = '';
	  $data['keywords'] = '';
      $data['page'] = 'index';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['slider'] = $this->View_data->getslider();
	  $data['news'] = $this->View_data->get_news();
	  $data['product'] = $this->View_data->get_product();
	  $data['products'] = $this->View_data->get_product();
	  $data['projects'] = $this->View_data->get_project_random();
	  $data['test'] = $this->Common_model->select_where_in('t_status', '1', 'testimonials');
	  $this->load->view('Frontend/index', $data);
    }

	public function infra()
    {
      $data['title'] = 'Infrastructure';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'site';
      $data['about'] = $this->View_data->about();
      $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
	  $data['infra'] = $this->Common_model->select('infrastructure');
      $this->load->view('Frontend/infra', $data);
    }

    public function sitemap()
    {
      $this->load->view('sitemap');
    }


	  public function vission()
    {
      $data['title'] = 'Vission & Mission';
      $data['page'] = 'Home';
	  $data['about'] = $this->View_data->about();	  
	  $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
	  $this->load->view('Frontend/vission', $data);
    }


   public function career()
    {
      $data['title'] = ' Home';
      $data['page'] = 'Home';
	  $data['about'] = $this->View_data->about();
	  $data['products'] = $this->View_data->get_product();
	  $data['contact'] = $this->View_data->getprofile();
	  $this->load->view('Frontend/career', $data);
    }


    public function news()
	{
      $data['title'] = ' News & Updates ';
      $data['page'] = 'Shopping-Cart';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
	  $data['news'] = $this->View_data->get_news();
      $this->load->view('Frontend/news', $data);
    }

	public function disclaimer()
	{
      $data['title'] = 'Camping at Bhandardara: Disclaimer ';
      $data['page'] = 'Shop-Cart';
      $data['description'] = '';
       $data['keywords'] = '';
	   $a_title = 'disclaimer';
	   $data['disclaimer'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
      $this->load->view('Frontend/disclaimer', $data);
    }

    public function privacy()
	{
      $data['title'] = 'Privacy Policy ';
      $data['page'] = 'Shop-Cart';
      $data['description'] = '';
       $data['keywords'] = '';	  
	   $a_title = 'privacy';
      $data['privacy'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
      $this->load->view('Frontend/privacy', $data);
    }

    public function terms()
	{
      $data['title'] = 'Terms & Conditions ';
      $data['page'] = 'terms';
      $data['description'] = '';
       $data['keywords'] = '';
	  $a_title = 'terms';
     $data['terms'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');	 
	 $data['about'] = $this->View_data->about();
	 $data['contact'] = $this->View_data->getprofile();
	 $data['products'] = $this->View_data->get_product();
      $this->load->view('Frontend/terms', $data);
    }

    public function about()
    {
      $data['title'] = '';
      $data['page'] = 'About';
      $data['description'] = '';
      $data['keywords'] = '';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
	  $quality = 'QUALITY';
	  $data['quality'] = $this->Common_model->select_where_in('a_title', $quality, 'articles');
	  $history = 'OUR HISTORY';
	  $data['history'] = $this->Common_model->select_where_in('a_title', $history, 'articles');
	  $supplies = 'OEM SUPPLIES';
	  $data['supplies'] = $this->Common_model->select_where_in('a_title', $supplies, 'articles');
	  $vision = 'OUR VISION';
	  $data['vision'] = $this->Common_model->select_where_in('a_title', $vision, 'articles');
	  $mission = 'OUR MISSION';
	  $data['mission'] = $this->Common_model->select_where_in('a_title', $mission, 'articles');
	  $chairman = 'CHAIRMAN';
	  $data['chairman'] = $this->Common_model->select_where_in('a_title', $chairman, 'articles');
	  $director = 'DIRECTOR';
	  $data['director'] = $this->Common_model->select_where_in('a_title', $director, 'articles');
	  $this->load->view('Frontend/about', $data);
    }

    public function product(){
      $data['title'] = 'Our Product ';
      $data['page'] = 'Product';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();  
	  $data['products'] = $this->View_data->get_product();
      $this->load->view('Frontend/product',$data);
    }
	public function project(){
      $data['title'] = 'Our Product ';
      $data['page'] = 'Product';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();  
	  $data['products'] = $this->View_data->get_product();
	  $data['projects'] = $this->View_data->get_project();
      $this->load->view('Frontend/projects',$data);
    }
	
	public function project_info($id)
	{
      $data['title'] = ' : News & Updates ';
      $data['page'] = 'News';
  	  $p_id = base64_decode($id);
  	  $data['about'] = $this->View_data->about();
  	  $data['contact'] = $this->View_data->getprofile();
  	  $data['products'] = $this->View_data->get_product();
  	  $data['project'] = $this->Common_model->select_by_id('p_id', $p_id, 'projects');
      $this->load->view('Frontend/project_info', $data);
    }
	
	public function supplier(){
      $data['title'] = 'Our Product ';
      $data['page'] = 'Product';
	  $data['about'] = $this->View_data->about();
	  $data['contact'] = $this->View_data->getprofile();  
	  $data['products'] = $this->View_data->get_product();
      $this->load->view('Frontend/supplier',$data);
    }

    public function gallery()
    {
      $data['title'] = 'Gallery ';
      $data['description'] = '';
      $data['keywords'] = '';
      $data['page'] = 'Gallery';
      $data['contact'] = $this->View_data->getprofile();
	  $data['products'] = $this->View_data->get_product();
      $data['about'] = $this->View_data->about();
	  $data['gt_type'] = $this->View_data->get_gtype();
      $data['gallery'] = $this->View_data->get_gallery();
      $this->load->view('Frontend/gallery',$data);
    }

   public function contact()
   {
     $data['title'] = ' Contact Us';
     $data['page'] = 'Contact';
	 $data['about'] = $this->View_data->about();
     $data['contact'] = $this->View_data->getprofile();
     $data['products'] = $this->View_data->get_product();
     $this->load->view('Frontend/contact',$data);
   }
   
   public function search()
   {
    if(!empty($_POST["search"])) {
		$query ="SELECT * FROM product WHERE p_name like '%" . $_POST["search"] . "%' ORDER BY p_id LIMIT 0,6";
		//$result = $db_handle->runQuery($query);
		$result = $this->db->query($query)->result();
	  echo "<ul>";
	  if(!empty($result)) {

		foreach($result as $country) {
			echo "<li><a href='".base_url().'product-details/'.rm_blank($country->p_name)."/".base64_encode($country->p_id)."'>".trim($country->p_name)."</a></li>";
		}

		}
		else {
			echo '<li>No Results Found. <small style=color:#0083c9>Please Search Another Keywords....</small></li>';
		}
	  }
	  echo "</ul>";
  }

	public function news_blog($id)
	{
      $data['title'] = ' : News & Updates ';
      $data['page'] = 'News';
  	  $n_id = base64_decode($id);
  	  $data['about'] = $this->View_data->about();
  	  $data['contact'] = $this->View_data->getprofile();
  	  $data['products'] = $this->View_data->get_product();
  	  $data['news'] = $this->Common_model->select_by_id('n_id', $n_id, 'news');
      $this->load->view('Frontend/news_blog', $data);
    }


  public function details($p_name,$p_id)
  {
    $data['title'] = ' : Our Product ';
    $data['page'] = 'Product';
	$p_id = base64_decode($p_id);
    $data['name'] = str_replace('-',' ',$p_name);
    $data['contact'] = $this->View_data->getprofile();
    $data['about'] = $this->View_data->about();
	$data['images'] = $this->Common_model->select_where_in2('p_id', $p_id,'a_status', '1', 'add_image');
	$data['video'] = $this->Common_model->select_where_in2('p_id', $p_id,'v_status', '1', 'add_video');
    $data['product'] = $this->View_data->get_product_id($p_id);
	$data['products'] = $this->View_data->get_product();
    $this->load->view('Frontend/product_details',$data);
  }

   public function video()
   {
    $data['title'] = ' : Video Gallery ';
    $data['page'] = 'Video';
    $data['description'] = '';
    $data['keywords'] = '';
    $data['video'] = $this->Common_model->select_by_id('v_status', '1' , 'video');
	$data['about'] = $this->View_data->about();
    $data['products'] = $this->View_data->get_product();
    $data['contact'] = $this->View_data->getprofile();   
    $this->load->view('Frontend/video',$data);
   }


  public function feedback()
   {
     $data['title'] = ' Feedback ';
     $data['page'] = 'Contact';
     $data['description'] = '';
     $data['keywords'] = '';
	 $data['about'] = $this->View_data->about();
	 $data['products'] = $this->View_data->get_product();
     $data['contact'] = $this->View_data->getprofile();  
     $this->load->view('Frontend/feedback',$data);
   }


}
