<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Site';
$route['home'] = 'Site/home';
$route['about'] = 'Site/about';
$route['view_site'] = 'site/view_site';
$route['in_enquiry'] = 'Insert/in_enquiry';
$route['fees'] = 'site/fees';
$route['how_it_work'] = 'site/how_it_work';
$route['documentation'] = 'site/documentation';
$route['(:any)-Varities-(:any)'] = 'site/spices/$1/$2';
$route['vision'] = 'site/vission';
$route['privacy'] = 'site/privacy';
$route['Terms-&-Conditions'] = 'site/terms';
$route['quality'] = 'site/quality';
$route['Mobile-App-Services'] = 'site/mobile_app';
$route['contact'] = 'site/contact';
$route['network'] = 'site/network';
$route['career'] = 'site/career';
$route['franchisee'] = 'site/franchisee';
$route['apply_for_franchisee'] = 'site/apply_online';
$route['franchisee_type'] = 'site/franchisee_type';
$route['in_enquiry'] = 'insert/in_enquiry';
$route['csp-provider-company'] = 'site/csp_provider_company';

$route['Error404'] = 'site/error';
$route['feedback'] = 'site/feedback';
$route['sitemap.xml'] = 'site/sitemap';



$route['terms_conditions'] = 'site/terms_conditions';
$route['privacy_policy'] = 'site/privacy_policy';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
